using System;
using System.Collections;
using System.Reflection;
using System.Drawing;

using Microsoft.DirectX;
using Microsoft.DirectX.DirectInput;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.SharedDLL
{
	public class ItemSpecialTrait
	{
		#region Properties
		private int m_nSpecialTraitDBID = 0;
		private double m_nValue = 0;

		private enumEntProperties m_nDenormalizedSpecialTraitEnum = enumEntProperties.LastItem; 
		#endregion

		public DSSerialize Serialize()
		{
			DSSerialize oSerialize = new DSSerialize();

			oSerialize.Set( 0,m_nSpecialTraitDBID );
			oSerialize.Set( 1,(int)m_nDenormalizedSpecialTraitEnum  );
			oSerialize.Set( 2,m_nValue );

			return( oSerialize );
		}
		public void DeSerialize( DSSerialize oSerialize )
		{
			m_nSpecialTraitDBID = oSerialize.GetInt( 0 );
			m_nDenormalizedSpecialTraitEnum = (enumEntProperties)oSerialize.GetInt( 1 );
			m_nValue = oSerialize.GetDouble( 2 );
		}


		public string GetTraitDescription()
		{
			DSGobTable oTraitsTable = null;
			string sRetVal = string.Empty;


			oTraitsTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_SPECIALTRAITS );
			sRetVal = (string)oTraitsTable.GetData( GobConstants.m_cCLMN_STRAITNAME,m_nSpecialTraitDBID );


			return( sRetVal );
		}

		public static double TotalValuesForTraits( ArrayList oSpecialTraits,enumEntProperties nTypeToTotalFor )
		{
			ItemSpecialTrait oLoopItem = null;
			double nValueTotal = 0;


			//Total our energy generation
			for( int i=0 ; i<oSpecialTraits.Count ; i++ )
			{
				oLoopItem = (ItemSpecialTrait)oSpecialTraits[ i ];
				if( oLoopItem.SpecialTraitEnum == nTypeToTotalFor )
				{
					nValueTotal += oLoopItem.Value;
				}
			}


			return( nValueTotal );
		}


		#region Properties
		public int SpecialTraitID
		{
			get
			{
				return( m_nSpecialTraitDBID );
			}
			set
			{
				m_nSpecialTraitDBID = value;
			}
		}	  
		public double Value
		{
			get
			{
				return( m_nValue );
			}
			set
			{
				m_nValue = value;
			}
		}	  
		public enumEntProperties SpecialTraitEnum
		{
			get
			{
				return( m_nDenormalizedSpecialTraitEnum );
			}
			set
			{
				m_nDenormalizedSpecialTraitEnum = value;
			}
		}
		#endregion
	}

	public class Item : Structure
	{
		#region Properties
		private DSNetPKey m_oPKey = null;
		private ComplexEntity m_oParentEntity = null;

		private enumItemLevel m_nItemLevel = enumItemLevel.Normal;
		private enumItemClass m_nItemClass = enumItemClass.Routine;
		private ArrayList m_oSpecialTraits = new ArrayList();
		private long m_nMinLevel = 0;

		private double m_nSpecialTrait_EnergyStoredThisFrame = 0;
		#endregion

		public virtual void CreatedAsNewItem()
		{
		}


        public virtual void Advance(Session oSession, double nElapsedTime)
		{
			double nChange = 0;


            if (this.ParentEntity.IsDead == false)
            {
                //Total our energy generation
                m_nSpecialTrait_EnergyStoredThisFrame = 0;
                nChange = ItemSpecialTrait.TotalValuesForTraits(m_oSpecialTraits, enumEntProperties.SpecialTraits_PowerTap);
                //Power generation is a bit odd, it can't be done by everyone but I don't want it to be
                //in the ComplexEntity because I have to re-do this logic.  So cheat.
                if (this.PKey == m_oParentEntity.BaseChassis.PKey)
                {
                    nChange += ItemSpecialTrait.TotalValuesForTraits(m_oParentEntity.LevelSpecialTraits, enumEntProperties.SpecialTraits_PowerTap);
                }
                m_nSpecialTrait_EnergyStoredThisFrame = nElapsedTime * nChange;

                //Regeneration
                nChange = nElapsedTime *
                        (ItemSpecialTrait.TotalValuesForTraits(m_oSpecialTraits, enumEntProperties.SpecialTraits_SelfRepair) +
                          ItemSpecialTrait.TotalValuesForTraits(m_oParentEntity.LevelSpecialTraits, enumEntProperties.SpecialTraits_SelfRepair));
                base.StructurePoints = DSMath.MoveTowords(base.MaxStructurePoints, base.StructurePoints, nChange);
            }
		}

		public virtual double GetPropertyTotal( enumEntProperties nPropertyToGet,bool bIncludeChildren )
		{
			double nPropertyTotal = 0;

			if( nPropertyToGet == enumEntProperties.Energy_Available )
			{
				nPropertyTotal += m_nSpecialTrait_EnergyStoredThisFrame;
			}
			else if( nPropertyToGet == enumEntProperties.Structure_Current )
			{
				nPropertyTotal += DSMisc.Max( 0,this.StructurePoints );
			}
			else if( nPropertyToGet == enumEntProperties.Structure_Max )
			{
				nPropertyTotal += DSMisc.Max( 0,this.MaxStructurePoints );
			}
			else if( nPropertyToGet == enumEntProperties.Structure_Mass )
			{
				nPropertyTotal += DSMisc.Max( 0,this.Mass );
			}
			else if( nPropertyToGet == enumEntProperties.Structure_PercentDamageRedux )
			{
				nPropertyTotal += DSMisc.Max( 0,this.PercentDamageRedux );
			}
			else if( nPropertyToGet == enumEntProperties.Structure_FixedDamageRedux )
			{
				nPropertyTotal += DSMisc.Max( 0,this.FixedDamageRedux );
			}

			//Get the rest of the special traits
			nPropertyTotal += GetSpecialTraitValue( nPropertyToGet );

			return( nPropertyTotal );
		}

		private double GetSpecialTraitValue( enumEntProperties nPropertyToGet )
		{
			ItemSpecialTrait oLoopItem = null;
			double nMyValue = 0;

			for( int i=0 ; i<m_oSpecialTraits.Count ; i++ )
			{
				oLoopItem = (ItemSpecialTrait)m_oSpecialTraits[ i ];
				if( oLoopItem.SpecialTraitEnum == nPropertyToGet )
				{
					nMyValue += oLoopItem.Value;
				}
			}

			return( nMyValue );
		}

		public virtual void RenderForEditor3D( System.Drawing.Rectangle oAreaToDrawAt,RenderSettings oRenderSettings )
		{			
		}

        
		public virtual void HoverStart()
		{
		}
		public virtual void HoverRender3D()
		{
		}
		public virtual ArrayList GetHoverRenderText()
		{
			ArrayList oProperties = new ArrayList();

			if( this.MinLevel > Globals.Inst().OurShip.LevelID )
			{
				oProperties.Add( "*Level " + this.MinLevel.ToString() + " Required*" );
			}

			return( oProperties );
		}
		public virtual void HoverStop()
		{
		}


		public virtual double TakeEnergy( double nAmountToTake )
		{
			double nTempAmountTaken = 0;

			if( nAmountToTake > m_nSpecialTrait_EnergyStoredThisFrame )
			{
				nTempAmountTaken = m_nSpecialTrait_EnergyStoredThisFrame;
				m_nSpecialTrait_EnergyStoredThisFrame = 0;
			}
			else if( m_nSpecialTrait_EnergyStoredThisFrame > nAmountToTake )
			{
				nTempAmountTaken = nAmountToTake;
				m_nSpecialTrait_EnergyStoredThisFrame -= nAmountToTake;
			}

			return( nTempAmountTaken );
		}


		public override DSSerialize Serialize(Session oSession)
		{
			ItemSpecialTrait oLoopItem = null;
			DSSerialize oSerialize = new DSSerialize();


			//Now save our data
            oSerialize.Set(0, base.Serialize(oSession));
			oSerialize.Set( 1,Convert.ToInt32( m_nItemLevel ) );
			oSerialize.Set( 2,Convert.ToInt32( m_nItemClass ) );
			oSerialize.SetList( 3 );
			for( int i=0 ; i<m_oSpecialTraits.Count ; i++ )
			{
				oLoopItem = (ItemSpecialTrait)m_oSpecialTraits[ i ];
				oSerialize.SetListItem( 3,oLoopItem.Serialize() );
			}
			oSerialize.Set( 4,this.PKeyObject.Serialize() );
			oSerialize.Set( 5,m_nMinLevel );


			return( oSerialize );
		}
        public override void DeSerialize(Session oSession, DSSerialize oSerialize)
		{
			ItemSpecialTrait oLoopItem = null;
			DSSerialize oSerItem = null;
			ArrayList oItemList = null;

			base.DeSerialize( oSession,(DSSerialize)oSerialize.Get( 0 ) );
			m_nItemLevel = (enumItemLevel)oSerialize.GetInt( 1 );
			m_nItemClass = (enumItemClass)oSerialize.GetInt( 2 );

			//Deserialize our traits
			oItemList = oSerialize.GetList( 3 );
			m_oSpecialTraits.Clear();
			for( int i=0 ; i<oItemList.Count ; i++ )
			{
				oSerItem = (DSSerialize)oItemList[ i ];
				oLoopItem = new ItemSpecialTrait();
				oLoopItem.DeSerialize( oSerItem );
				m_oSpecialTraits.Add( oLoopItem );
			}
			this.PKeyObject.DeSerialize( (DSSerialize)oSerialize.Get( 4 ) );
			m_nMinLevel = oSerialize.GetLong( 5 );
		}

        
		#region Properties
		public string PKey
		{
			get
			{
				return( m_oPKey.ToString() );
			}
		}
		public DSNetPKey PKeyObject
		{
			set
			{
				m_oPKey = value;
			}
			get
			{
				return( m_oPKey );
			}
		}

		public enumItemLevel ItemLevel
		{
			get
			{
				return( m_nItemLevel );
			}
			set
			{
				m_nItemLevel = value;
			}
		}
		public enumItemClass ItemClass
		{
			get
			{
				return( m_nItemClass );
			}
			set
			{
				m_nItemClass = value;
			}
		}
		public ArrayList SpecialTraits
		{
			get
			{
				return( m_oSpecialTraits );
			}
			set
			{
				m_oSpecialTraits = value;
			}
		}
		public virtual string Name
		{
			get
			{
				string sName = this.GetType().ToString();
				int nPos = sName.LastIndexOf( "." );
				sName = sName.Substring( nPos+1 );
				return( sName );
			}
		}
		public virtual ComplexEntity ParentEntity
		{
			get
			{
				return( m_oParentEntity );
			}
			set
			{
				m_oParentEntity = value;
			}
		}
		public virtual bool Active
		{
			get
			{
				return( true );
			}
		}
		public long MinLevel
		{
			get
			{
				return( m_nMinLevel );
			}
			set
			{
				m_nMinLevel = value;
			}
		}
		#endregion
	}
}